unit Unit1;

interface 

uses 
Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, 
ExtCtrls, Math, StdCtrls, Buttons, Printers;

type 
    TForm1 = class(TForm)
    Image1: TImage;
    BitBtn1: TBitBtn;
    Button1: TButton;
    PrintDialog1: TPrintDialog;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);

private
{ Private declarations } 
    ChartSize, ChartCenter, X1,X2,Y1,Y2 : Integer;
    Index, SubIndex : Real;
    PixelsInInchX: integer;       { Stores Pixels per inch }
    PixelsInInchY: integer;
    PixelsInCentX: integer;
    PixelsInCentY: integer;
    PageW, PageH, CenterPageX, CenterPageY : Integer;
    Function Normal360(x : Real):Real;
    Procedure DrawDial360; 
public
{ Public declarations } 
end;

var 
Form1: TForm1; 

implementation 


{$R *.DFM} 

Function TForm1.Normal360(x : Real):Real; 
begin 
  Repeat
    if X<0 then X := X+360;
    if X>=360 then X := X-360;
  until (X>=0)and(X<360);
  Result := X;
end; 

Procedure TForm1.DrawDial360;
Var I,E : Integer; 
begin 
  With Image1.Canvas do begin
       Pen.Color := RGB ( 0, 0, 85);
       Image1.Canvas.Brush.Style := bsSolid;
       Rectangle( 0, 0,ChartSize,ChartSize);
       Pen.Color := RGB (255, 0,64);
       Image1.Canvas.Brush.Style := bsClear;
       Ellipse(ChartCenter-140, ChartCenter-140, ChartCenter+140, ChartCenter+140);
       Pen.Color := ClPurple;
       Ellipse(ChartCenter-120, ChartCenter-120, ChartCenter+120, ChartCenter+120);
       Ellipse(ChartCenter-10, ChartCenter-10, ChartCenter+10, ChartCenter+10);

       for I:=1 to 12 do begin // 12 Main Lines
           SubIndex := Index+(I*30); Normal360(SubIndex);
           X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
           Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
           X2 := ChartCenter-Trunc(10*Sin(SubIndex*pi/180));
           Y2 := ChartCenter-Trunc(10*Cos(SubIndex*pi/180));
           Case I of
            3 : Pen.Color := RGB(0,0,255); // First House
           12 : Pen.Color := RGB(255,0,0); // Tenth House
           else Pen.Color := ClPurple;
           end;
           Moveto(X1,Y1);
           Lineto(X2,Y2);
           if I in [3,6,9,12] then begin // Arrow on Square Point
              X2 := ChartCenter-Trunc(120*Sin((SubIndex+5)*pi/180));
              Y2 := ChartCenter-Trunc(120*Cos((SubIndex+5)*pi/180));
              Moveto(X1,Y1); Lineto(X2,Y2);
              X2 := ChartCenter-Trunc(120*Sin((SubIndex-5)*pi/180));
              Y2 := ChartCenter-Trunc(120*Cos((SubIndex-5)*pi/180));
              Moveto(X1,Y1); Lineto(X2,Y2);
           end;
       end;

       Pen.Color := RGB(255,0,64);
       for I:=0 to 3 do begin // Arrow at 4 of 45 Degree
           SubIndex := Index+45+(I*90); Normal360(SubIndex);
           X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
           Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
           X2 := ChartCenter-Trunc(120*Sin(SubIndex*pi/180));
           Y2 := ChartCenter-Trunc(120*Cos(SubIndex*pi/180));
           Moveto(X1,Y1);
           Lineto(X2,Y2);

           X2 := ChartCenter-Trunc(120*Sin((SubIndex+2)*pi/180));
           Y2 := ChartCenter-Trunc(120*Cos((SubIndex+2)*pi/180));
           Moveto(X1,Y1); Lineto(X2,Y2);
           X2 := ChartCenter-Trunc(120*Sin((SubIndex-2)*pi/180));
           Y2 := ChartCenter-Trunc(120*Cos((SubIndex-2)*pi/180));
           Moveto(X1,Y1); Lineto(X2,Y2);
       end;

       for I:=1 to 71 do // Every 5 Degree
           if I in [6,9,12,18,24,27,30,36,42,45,48,54,60,63,66] then else
           begin
             SubIndex := Index+(I*5); Normal360(SubIndex);
             if (I mod 3)=0 then E:=125 else E:=130;
             X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
             Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
             X2 := ChartCenter-Trunc(E*Sin(SubIndex*pi/180));
             Y2 := ChartCenter-Trunc(E*Cos(SubIndex*pi/180));
             Moveto(X1,Y1);
             Lineto(X2,Y2);
           end;

       for I := 1 to 359 do // Mini Lines Every Degree
           if (I mod 5) = 0 then else
           begin
             SubIndex := Index+I; Normal360(SubIndex);
             X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
             Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
             X2 := ChartCenter-Trunc(135*Sin(SubIndex*pi/180));
             Y2 := ChartCenter-Trunc(135*Cos(SubIndex*pi/180));
             Moveto(X1,Y1);
             Lineto(X2,Y2);
           end;
  end; // With
end; 

procedure TForm1.FormCreate(Sender: TObject); 
begin 
  ChartSize := Image1.Width;
  ChartCenter := Round(ChartSize/2);
  Index := 90;
  DrawDial360; 
end; 


procedure TForm1.Button1Click(Sender: TObject);
Var I,E : Integer;  EE, Index90, SubIndex90 : Real;
begin
  if PrintDialog1.Execute then begin
     PixelsInInchx := GetDeviceCaps(Printer.Handle, LOGPIXELSX); { Get Pixels per inch horizonally}
     PixelsInInchY := GetDeviceCaps(Printer.Handle, LOGPIXELSY); { Get Pixels per inch vertically}
     PixelsInCentX := Trunc(PixelsInInchx / 2.54);
     PixelsInCentY := Trunc(PixelsInInchY / 2.54);
     PageW := Printer.PageWidth;
     PageH := Printer.PageHeight;
     CenterPageX := PageW div 2;
     CenterPageY := (PageH div 2)-Trunc(3.5*PixelsInCentY);
  Try
     Printer.BeginDoc;
     Application.ProcessMessages;                       { Allow Drawing of abort box }
     With Printer.Canvas do begin
          Brush.Style := bsClear;
          Font.Name := 'AngsanaUPC';
          Font.Size := 16;
          TextOut(PixelsInCentX, PixelsInCentY, 'Test Printing with Delphi');

          if PixelsInInchX<300 then Pen.Width :=1 else Pen.Width := 3;
          Pen.Color := RGB ( 0, 0, 85);
          Ellipse(Trunc(CenterPagex-PixelsInCentx*0.3), Trunc(CenterPageY-PixelsInCentY*0.3),
                  Trunc(CenterPagex+PixelsInCentx*0.3), Trunc(CenterPageY+PixelsInCentY*0.3));
          Ellipse(Trunc(CenterPagex-PixelsInCentx*6),   Trunc(CenterPageY-PixelsInCentY*6),
                  Trunc(CenterPagex+PixelsInCentx*6),   Trunc(CenterPageY+PixelsInCentY*6));
          Ellipse(Trunc(CenterPagex-PixelsInCentx*5.0), Trunc(CenterPageY-PixelsInCentY*5.0),
                  Trunc(CenterPagex+PixelsInCentx*5.0), Trunc(CenterPageY+PixelsInCentY*5.0));
     end; // with Printer

     With Printer.Canvas do begin

        for I:=1 to 12 do begin  // 12 Main Lines
            SubIndex := Index+(I*30); Normal360(SubIndex);
            X1 := CenterPageX-Trunc(PixelsInCentX*6*Sin(SubIndex*pi/180));
            Y1 := CenterPageY-Trunc(PixelsInCentY*6*Cos(SubIndex*pi/180));
            X2 := CenterPageX-Trunc(PixelsInCentX*0.3*Sin(SubIndex*pi/180));
            Y2 := CenterPageY-Trunc(PixelsInCentY*0.3*Cos(SubIndex*pi/180));
            Case I of
                  3 : begin   // First House
                        Pen.Color := RGB(0,0,255);
                      end;
                 12 : begin   // Tenth House
                        Pen.Color := RGB(255,0,0);
                      end;
                 else  Pen.Color := ClPurple;
            end;
            Moveto(X1,Y1);
            Lineto(X2,Y2);


            X2 := CenterPageX-Trunc(PixelsInCentX*4.0*Sin((SubIndex-15)*pi/180));
            Y2 := CenterPageY-Trunc(PixelsInCentY*4.0*Cos((SubIndex-15)*pi/180));
            X2 := X2-Trunc((PixelsInCentX*0.5)/(PixelsInCentX*12)*(CenterPageX+(PixelsInCentX*6)-X2));
            Y2 := Y2-Trunc((PixelsInCentY*0.5)/(PixelsInCentY*12)*(CenterPageY+(PixelsInCentY*6)-Y2));

            if I in [3,6,9,12] then begin         // Arrow on Square Point
               X2 := CenterPageX-Trunc(PixelsInCentX*5.0*Sin((SubIndex+2)*pi/180));
               Y2 := CenterPageY-Trunc(PixelsInCentY*5.0*Cos((SubIndex+2)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
               X2 := CenterPageX-Trunc(PixelsInCentX*5.0*Sin((SubIndex-2)*pi/180));
               Y2 := CenterPageY-Trunc(PixelsInCentY*5.0*Cos((SubIndex-2)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
            end;
        end;

        Pen.Color := RGB(255,0,64);
        for I:=0 to 3 do begin  // Arrow at 4 of 45 Degree
            SubIndex := Index+45+(I*90); Normal360(SubIndex);
            X1 := CenterPageX-Trunc(PixelsInCentX*6*Sin(SubIndex*pi/180));
            Y1 := CenterPageY-Trunc(PixelsInCentY*6*Cos(SubIndex*pi/180));
            X2 := CenterPageX-Trunc(PixelsInCentX*5.0*Sin(SubIndex*pi/180));
            Y2 := CenterPageY-Trunc(PixelsInCentY*5.0*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
               X2 := CenterPageX-Trunc(PixelsInCentX*5.0*Sin((SubIndex+2)*pi/180));
               Y2 := CenterPageY-Trunc(PixelsInCentY*5.0*Cos((SubIndex+2)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
               X2 := CenterPageX-Trunc(PixelsInCentX*5.0*Sin((SubIndex-2)*pi/180));
               Y2 := CenterPageY-Trunc(PixelsInCentY*5.0*Cos((SubIndex-2)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
        end;

        for I:=1 to 71 do   // Every 5 Degree
         if I in [6,9,12,18,24,27,30,36,42,45,48,54,60,63,66] then else
         begin
            SubIndex := Index+(I*5); Normal360(SubIndex);
            if (I mod 3)=0 then EE:=5.2 else EE:=5.5;
            X1 := CenterPageX-Trunc(PixelsInCentX*6*Sin(SubIndex*pi/180));
            Y1 := CenterPageY-Trunc(PixelsInCentY*6*Cos(SubIndex*pi/180));
            X2 := CenterPageX-Trunc(PixelsInCentX*EE*Sin(SubIndex*pi/180));
            Y2 := CenterPageY-Trunc(PixelsInCentY*EE*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
         end;
        for I := 1 to 359 do  // Mini Lines Every Degree
         if (I mod 5) = 0 then else
         begin
            SubIndex := Index+I; Normal360(SubIndex);
            X1 := CenterPageX-Trunc(PixelsInCentX*6*Sin(SubIndex*pi/180));
            Y1 := CenterPageY-Trunc(PixelsInCentY*6*Cos(SubIndex*pi/180));
            X2 := CenterPageX-Trunc(PixelsInCentX*5.7*Sin(SubIndex*pi/180));
            Y2 := CenterPageY-Trunc(PixelsInCentY*5.7*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
         end;

     end;
     Printer.EndDoc;
  except
    on E: Exception do MessageDlg(E.Message, mtError, [mbok], 0);
  end;
  end;
end;

end.

