unit Umain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Button_doit: TButton;
    Button_exit: TButton;
    Combo_EW: TComboBox;
    Combo_NS: TComboBox;
    Combo_hsys: TComboBox;
    Day: TEdit;
    lat_deg: TEdit;
    lat_min: TEdit;
    lat_sec: TEdit;
    Month: TEdit;
    Year: TEdit;
    Hour: TEdit;
    Minute: TEdit;
    Second: TEdit;
    lon_deg: TEdit;
    lon_min: TEdit;
    lon_sec: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    outfld: TMemo;
    RadioGroup1: TRadioGroup;
    procedure Button_doitClick(Sender: TObject);
    procedure Button_exitClick(Sender: TObject);
    procedure Form1CloseQuery(Sender: TObject; var CanClose: boolean);
  private
    { private declarations }
    iday, imonth, ibe, iyear, ihour, imin, isec: Integer;
    xx    : Array[0..5] of double;
    serr :  Array[0..255] of Char;

    tjd, tjdet, tjdut, tsid, armc, dhour, deltat : double;
    eps_true, nut_long: double;
    glon, glat: double;
    sjul: String[30];
    sout: string[255];
    iflag, rflag : Longint;
    ilondeg, ilonmin, ilonsec, ilatdeg, ilatmin, ilatsec: Integer;
    hcusps: array[0..12] of double;
    ascmc: array[0..9] of double;
    pname: array[0..19] of Char;

    Point, Ret : array[0..47] of Double;

    Procedure UranianCalc;
    Procedure Display;
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

uses UsweCalc;

{ TForm1 }

procedure TForm1.UranianCalc;
Var
  i : integer;
begin
  if RadioGroup1.ItemIndex=0 then begin
     iflag := seflg_speed;
  end else begin
     iflag := seflg_speed+SEFLG_SIDEREAL;
     swe_set_sid_mode(SE_SIDM_LAHIRI, 0, 0);
  end;
  iday := StrToInt(day.Text);
  imonth := StrToInt(month.Text);
  ibe := StrToInt(year.Text);
  if (imonth<4) and (ibe<2484) then iyear := ibe-542 else iyear := ibe-543;
  ihour := StrToInt(hour.Text);
  imin := StrToInt(minute.Text);
  isec := StrToInt(second.Text);
  ilondeg := StrToInt(lon_deg.Text);
  ilonmin := StrToInt(lon_min.Text);
  ilonsec := StrToInt(lon_sec.Text);
  ilatdeg := StrToInt(lat_deg.Text);
  ilatmin := StrToInt(lat_min.Text);
  ilatsec := StrToInt(lat_sec.Text);
  dhour := ihour + imin / 60.0 + isec / 3600.0;
  tjd := swe_julday(iyear, imonth, iday, dhour, 1)-7/24;
  deltat := swe_deltat(tjd);

    {input date is Universal Time}
    Str((deltat * 86400):16:10,  sjul);
    sout := 'deltat:     ' + sjul + ' sec';
    tjdut := tjd;
    tjdet := tjd + deltat;
    Str(tjdut:10:8,  sjul);
    sjul := sjul + ' UT';

  { planets }
  for i := SE_SUN to SE_POSEIDON do if (i<=SE_TRUE_NODE) or (i>=SE_CUPIDO) then
    begin
      rflag := swe_calc(tjdet, i, iflag, xx[0], serr);
      Point[i] := xx[0];
      Ret[i]   := xx[3];
    end;
  { for houses: ecliptic obliquity and nutation }
  rflag := swe_calc(tjdet, SE_ECL_NUT, 0, xx[0], serr);
  eps_true := xx[0];
  nut_long := xx [2];
  { geographic position }
  glon := ilondeg + ilonmin / 60.0 + ilonsec / 3600.0;
  if (combo_EW.ItemIndex > 0) then glon := -glon;
  glat := ilatdeg + ilatmin / 60.0 + ilatsec / 3600.0;
  if (combo_NS.ItemIndex > 0) then glat := -glat;
  { sidereal time }
  tsid := swe_sidtime(tjdut);
  tsid := tsid + glon / 15;
  armc := tsid * 15;
  { house method }
  i := combo_hsys.ItemIndex;
  if (i < 0) then i := 0;
  swe_houses_ex(tjdut, iflag, glat, glon, hsys[i], hcusps[0], ascmc[0]);
end;

Procedure TForm1.Display;
type
   tZodiacString = String[30];
const
   ZodiacNames : array [0..11] of string[4] =
   ('  ', '  ', '  ', '  ', '  ', '  ',
    '  ', '  ', '  ', '  ', '  ', '  ');
   DayNames    : array [0..6] of String =
   ('ѹ', 'ѧ', 'ظ', 'ʺ', 'ء', '', 'ҷԵ');
Var
   i, j: integer;

procedure ZodiacName (juldate: double; var zs: tZodiacString);
var
  degree, sign, minute: integer;
  ms: tZodiacString;
begin
  juldate := juldate + 1/120; { allows correct rounding }
  sign := trunc(juldate/30);
  degree := trunc(juldate) - sign*30;
  minute := trunc(frac(juldate) * 60);
  Str(degree:3, zs);
  Str(minute:2, ms);
  if ms[1] = ' ' then ms[1] := '0';
  zs := zs + ZodiacNames[sign] + ms;
end;

begin
  outfld.clear;
  sout := 'ӹǹѹ¹:   ' + sjul;
  outfld.Lines.Add(sout);
  sout := 'çѺѹ'+DayNames[Trunc(tjdut+0.5+7/24)mod 7];
  outfld.Lines.Add( sout);
  outfld.Lines.Add(' ');

  for i := SE_SUN to SE_POSEIDON do if (i<=SE_TRUE_NODE) or (i>=SE_CUPIDO) then
    begin
      ZodiacName(Point[i], sjul);
      swe_get_planet_name(i, pname);
      if Ret[i] < 0 then sjul := sjul + ' ';
      sout := StrPas(pname);
      for j := StrLen(pname) to 11 do sout := sout + ' ';
      sout := sout + sjul;
      outfld.Lines.Add( sout);
    end;

  outfld.Lines.Add(' ');
  Str(tsid:16:10, sjul);
  sout := 'ҹѡѵ   ' + sjul;
  outfld.Lines.Add( sout);
  Str(armc:16:10, sjul);
  sout := 'ARMC        ' + sjul;
  outfld.Lines.Add( sout);
  ZodiacName(ascmc[0], sjul);
  sout := 'Ѥ   ' + sjul;
  outfld.Lines.Add( sout);
  ZodiacName(ascmc[1], sjul);
  sout := '¹    ' + sjul;
  outfld.Lines.Add( sout);
  ZodiacName(ascmc[3], sjul);
  sout := 'vertex      ' + sjul;
  outfld.Lines.Add( sout);
  outfld.Lines.Add( '');
  sout := '͹ек ' + combo_hsys.Text;
  outfld.Lines.Add( sout);
  outfld.Lines.Add( '');
  for i := 1 to 12 do
    begin
      Str(i:2, sjul);
      sout := '͹еҷ ' + sjul + '    ';
      ZodiacName(hcusps[i], sjul);
      sout := sout + sjul;
      outfld.Lines.Add( sout);
    end;
  if RadioGroup1.ItemIndex=1 then begin
     sout := FloatToStr(swe_get_ayanams(tjdet));
     outfld.Lines.Add('¹ҧ = '+sout);
  end;
end;

procedure TForm1.Button_exitClick(Sender: TObject);
begin
  swe_close;
  close;
  Exit;
end;

procedure TForm1.Form1CloseQuery(Sender: TObject; var CanClose: boolean);
begin
  CanClose := (MessageDlg('ͧԡҹ?', mtConfirmation, [mbYes, mbNo], 0) = mrYes);
end;

procedure TForm1.Button_doitClick(Sender: TObject);
begin
  UranianCalc;
  Display;
end;

initialization
  {$I Umain.lrs}

end.

