unit UnitDrawDial; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  Buttons, StdCtrls, Math, ActnList;

type
  TForm1 = class(TForm)
    BitBtn1: TBitBtn;
    Image1: TImage;
    Label1: TLabel;
    procedure Form1Create(Sender: TObject);
    procedure Form1Paint(Sender: TObject);
    procedure Image1MouseDown(Sender: TOBject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer
      );
    procedure Image1MouseUp(Sender: TOBject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { private declarations }
    ChartSize, ChartCenter, X1,X2,Y1,Y2 : Integer;
    Index, SubIndex, RotateAngle1, RotateAngle2        : Real;
    DialRotate : Boolean;
    Function FindDistance(x,y : Integer): Integer;
    Function Normal360(x : Real):Real;
    Procedure DrawDial360;
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.Image1MouseDown(Sender: TOBject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if FindDistance(x,y) in [10..140] then begin
     DialRotate := True;
     RotateAngle1 := ArcTan2((X-ChartCenter),(y-ChartCenter))*180/pi;
     Screen.Cursor := crHandPoint;
     Image1.Cursor := Screen.Cursor;
  end;
end;

procedure TForm1.Form1Create(Sender: TObject);
begin
  ChartSize   := Image1.Width;
  ChartCenter := Round(ChartSize/2);
  Index := 90;
  DrawDial360;
end;

procedure TForm1.Form1Paint(Sender: TObject);
begin
  //DrawDial360;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if DialRotate and (FindDistance(x,y) in [10..140]) then begin
     RotateAngle2 := ArcTan2((X-ChartCenter),(y-ChartCenter))*180/pi;
     Screen.Cursor := crHandPoint;
     Image1.Cursor := Screen.Cursor;
     Index := Index+(RotateAngle2-RotateAngle1);
     Index := Normal360(Index);
     DrawDial360;
     RotateAngle1 := RotateAngle2;
     DrawDial360;
  end;
end;

procedure TForm1.Image1MouseUp(Sender: TOBject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  If DialRotate then begin
     DialRotate := False;
     Screen.Cursor := crDefault;
     Image1.Cursor := Screen.Cursor;
  end;
end;

function TForm1.FindDistance(x, y: Integer): Integer;
begin
  if X= ChartCenter then FindDistance := abs(y-ChartCenter) else if y= ChartCenter then FindDistance := abs(X-ChartCenter)
     else FindDistance := Trunc(Sqrt(sqr(X-ChartCenter)+sqr(y-ChartCenter)));
end;

function TForm1.Normal360(x: Real): Real;
begin
  Repeat
    if X<0 then X := X+360;
    if X>=360 then X := X-360;
  until (X>=0)and(X<360);
  Result := X;
end;

procedure TForm1.DrawDial360;
Var I,E : Integer;
begin
   With Image1.Canvas do begin
        //Pen.Color := RGB ( 0, 0, 85);
        Brush.Style := bsSolid;
        Rectangle( 0, 0,ChartSize-1,ChartSize-1);
        //Pen.Color := RGB (255, 0,64);
        Brush.Style := bsClear;
        Ellipse(ChartCenter-140, ChartCenter-140, ChartCenter+140, ChartCenter+140);
        Pen.Color := ClPurple;
        Ellipse(ChartCenter-120, ChartCenter-120, ChartCenter+120, ChartCenter+120);
        Ellipse(ChartCenter-10, ChartCenter-10, ChartCenter+10, ChartCenter+10);
        for I:=1 to 12 do begin  // 12 Main Lines
            SubIndex := Index+(I*30); Normal360(SubIndex);
            X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
            Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
            X2 := ChartCenter-Trunc(10*Sin(SubIndex*pi/180));
            Y2 := ChartCenter-Trunc(10*Cos(SubIndex*pi/180));
            Case I of
                  3 : Pen.Color := clBlue;  // First House
                 12 : Pen.Color := clRed;  // Tenth House
                 else  Pen.Color := ClPurple;
            end;
            Moveto(X1,Y1);
            Lineto(X2,Y2);
            if I in [3,6,9,12] then begin         // Arrow on Square Point
               X2 := ChartCenter-Trunc(120*Sin((SubIndex+5)*pi/180));
               Y2 := ChartCenter-Trunc(120*Cos((SubIndex+5)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
               X2 := ChartCenter-Trunc(120*Sin((SubIndex-5)*pi/180));
               Y2 := ChartCenter-Trunc(120*Cos((SubIndex-5)*pi/180));
               Moveto(X1,Y1); Lineto(X2,Y2);
            end;
        end;
        //Pen.Color := RGB(255,0,64);
        for I:=0 to 3 do begin  // Arrow at 4 of 45 Degree
            SubIndex := Index+45+(I*90); Normal360(SubIndex);
            X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
            Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
            X2 := ChartCenter-Trunc(120*Sin(SubIndex*pi/180));
            Y2 := ChartCenter-Trunc(120*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
            X2 := ChartCenter-Trunc(120*Sin((SubIndex+2)*pi/180));
            Y2 := ChartCenter-Trunc(120*Cos((SubIndex+2)*pi/180));
            Moveto(X1,Y1); Lineto(X2,Y2);
            X2 := ChartCenter-Trunc(120*Sin((SubIndex-2)*pi/180));
            Y2 := ChartCenter-Trunc(120*Cos((SubIndex-2)*pi/180));
            Moveto(X1,Y1); Lineto(X2,Y2);
        end;
        for I:=1 to 71 do   // Every 5 Degree
         if I in [6,9,12,18,24,27,30,36,42,45,48,54,60,63,66] then else
         begin
            SubIndex := Index+(I*5); Normal360(SubIndex);
            if (I mod 3)=0 then E:=125 else E:=130;
            X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
            Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
            X2 := ChartCenter-Trunc(E*Sin(SubIndex*pi/180));
            Y2 := ChartCenter-Trunc(E*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
         end;
        for I := 1 to 359 do  // Mini Lines Every Degree
         if (I mod 5) = 0 then else
         begin
            SubIndex := Index+I; Normal360(SubIndex);
            X1 := ChartCenter-Trunc(140*Sin(SubIndex*pi/180));
            Y1 := ChartCenter-Trunc(140*Cos(SubIndex*pi/180));
            X2 := ChartCenter-Trunc(135*Sin(SubIndex*pi/180));
            Y2 := ChartCenter-Trunc(135*Cos(SubIndex*pi/180));
            Moveto(X1,Y1);
            Lineto(X2,Y2);
         end;
   end;     // With
   Label1.Caption := 'Index = '+FloatToStr(index)+' Degree(s)';
end;

initialization
  {$I UnitDrawDial.lrs}
end.

